#ifndef _NSWFL_H
#define _NSWFL_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//_NETLOGO_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct _AboutDialogInfo{
    char *BuildDate;
    char *BuildTime;
    char *CopyRight;
    char *FileVersion;
    char *TitleCaption;
    HICON DisplayIcon;
    HWND OwnerHandle;
} ABOUTDLGINFO, *LPABOUTDLGINFO;

bool IsNetLogoActive(void);
bool NetLogo(LPABOUTDLGINFO lpADI);
HWND NetLogoHandle(void);
void EndNetLogo(void);

//_DATETIME_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool TimetToLocalTime(time_t MyTime_T, LPSYSTEMTIME pLT);
bool TimetToSystemTime(time_t MyTime_T, LPSYSTEMTIME pST);
DWORD DateToLong(int iYear, int iMonth, int iDay);
DWORD TimeToLong(int iHour, int iMin, int iSec);
void LongToDate(DWORD dwDate, int *piYear, int *piMonth, int *piDay);
void LongToTime(DWORD dwTime, int *piHour, int *piMin, int *piSec);
void TimetToFileTime(time_t t, LPFILETIME pft);

//_KEYGENERATIION_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define GKNUMBERS        0x1
#define GKUPPER_AZ       0x2
#define GKLOWER_AZ       0x4
#define GKBROADKEY       0x8
#define GKNONREPETITION  0x16

bool GenerateKey(int iNewKeyLen, long lSeed, int iAttribs, char *sOutKey);
long GenerateSeed(void);

//_LISTBOX_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
char *ListBoxItemText(HWND hWnd, int iItemPos);
int ClearListBox(HWND hWnd);
int CountListBoxItems(HWND hWnd);
int CurrentListBoxItem(HWND hWnd);
int DeleteListBoxItem(HWND hWnd, int iItemPos);
int HorizontalListBoxExtent(HWND hWnd, int iHorzExtent);
int InsertListBoxItem(HWND hWnd, const char *sInStr, int iInsertPos);
int InsertListBoxItemEx(HWND hWnd, const char *sInStr, int iMaxItems, int iInsertPos);
int ListBoxItemLength(HWND hWnd, int iItemPos);
int SelectListBoxItem(HWND hWnd, int iItemPos);
int SelectMultipleListBoxItem(HWND hWnd, int iItemPos, BOOL Select);
void ListBoxItemTextEx(HWND hWnd, int iItemPos, char *sOutVal);

//_MATH_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
DWORD VersionToLong(int iBit1, int iBit2, int iBit3, int iBit4);
int HiByte (unsigned int iInput);
int IntLength(int iIn);
int LoByte (unsigned int iInput);
int LongLength(long lIn);
int ReverseInt(int iIn);
int ReverseLong(long lIn);
int SquareRoot (int iInput);
void LongToVersion(DWORD dwInVer, int *iBit1, int *iBit2, int *iBit3, int *iBit4);

//_MEMORY_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool Free(void *vBuffer);
int MemCopyInt(char *sOutBuf, int iIn);
int MemCopyLong(char *sOutBuf, long lIn);
void *Allocate(int iBlockSz);
void *ClearMem(void *vBuffer, int iBufSz);
void *MemCopy(void *vTarget, void *vSource, int iLen);

//_Conversion_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
char * DoubleChar (double dInput);
char * FloatChar (float fInput);
char * IntChar (int iInput);
char * LongChar (DWORD dwInput);
double CharDouble (const char *sInput);
DWORD CharLong (const char *sInput);
float CharFloat (const char *sInput);
int CharInt (const char *sInput);
void DoubleCharEx (double dInput, char *sOutVal);
void FloatCharEx (float fInput, char *sOutVal);
void IntCharEx (int iInput, char *sOutVal);
void LongCharEx (DWORD dwInput, char *sOutVal);

//_QUEUSYSTEM_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct _QueuSystem{
    char **Data;
    int *DataSize;
    int MaxItems;
    int UsedItems;
} QUEUSYSTEM, *LPQUEUSYSTEM;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool AddQueuItem(LPQUEUSYSTEM lpQS, void *vInBuf, int iInBufSz);
bool DeleteQueuItem(LPQUEUSYSTEM lpQS, int iItem);
bool FreeQueu(LPQUEUSYSTEM lpQS);
bool InitilizeQueu(LPQUEUSYSTEM lpQS, int iMaxItems);
int GetQueuItem(LPQUEUSYSTEM lpQS, int iItem, void *vOutBuf);
int ReadQueuItem(LPQUEUSYSTEM lpQS, int iItem, void *vOutBuf);

//_REGISTRY_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool CreateRegistryKey(HKEY hKeyRoot, LPCTSTR pszSubKey);
bool DeleteRegistryKey(HKEY hKeyRoot, LPCTSTR pszSubKey);
bool DeleteRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue);
bool Get_BinaryRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, PVOID pBuffer, DWORD& rdwSize);
bool Get_BOOLRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue);
bool Get_DWORDRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, DWORD &rdwBuff);
bool Get_StringRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, LPTSTR pszBuffer, DWORD& rdwSize);
bool Set_BinaryRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, PVOID pData, DWORD dwSize);
bool Set_BOOLRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, bool bVal);
bool Set_DWORDRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, DWORD dwValue);
bool Set_StringRegistryValue(HKEY hKeyRoot, LPCTSTR pszSubKey, LPCTSTR pszValue, LPCTSTR pszString);

//WINSFL_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define OFD 1 //Open File Dialog (For OSFileDialog())
#define SFD 2 //Save File Dialog (For OSFileDialog())

bool BrowseDirectory(HWND hOwner, char *sInTitle, unsigned long ulFlags, char *sOutBuf);
char *Get_Text (HWND hWnd);
DWORD Get_Long(HWND hWnd);
HFONT MakeFont(char *sFontName, int iPointSize);
int Get_Int(HWND hWnd);
int Get_TextEx (HWND hWnd, char *sOutBuf, int iMaxSize);
int Get_TextLength(HWND hWnd);
int IsMouseOverHwnd(HWND hWnd);
int OSFileDialog (HWND hOwner, char *sInOutFileName, char *sInDfltExt, char *sInTitle, char *sInFilters, char *sInDfltDir, int iDlgType, DWORD dwFlags);
LRESULT CALLBACK Set_Color(int iFGColor, int iBKColor, int wParam);
void AlertMessage(HWND hWnd, char *sInBuf, char *sTitle);
void CenterWindow (HWND hWnd);
void ErrorMessage(HWND hWnd, char *sInBuf);
void MsgBox(char *sInBuf);
void Set_Int(HWND hWnd, int iInput);
void Set_Long(HWND hWnd, long lInput);
void Set_Text (HWND hWnd, char *sInBuf);
void SetFont(HWND hWnd, HFONT hFont);
void TextBoxWrite(HWND hWnd, char *sInBuf);

//SYSTEM_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define FAccess  6   // Check for read and write permission
#define FRead    4   // Check for read permission
#define FWrite   2   // Check for write permission
#define FExecute 1   // Execute (Ignored)
#define FExist   0   // Check for existence of file

bool FileAccess(const char *sFileName, short iMode);
BOOL Get_MachineNameEx (char *sOutVal);
BOOL Get_UserNameEx (char *sOutVal);
bool IsDirectory(const char *sPath);
bool IsWinNT(void);
BOOL ResetWindowsSys(UINT uFlags);
char * Get_CurrentDirectory (void);
char * Get_LongDate (void);
char * Get_MachineName (void);
char * Get_OsVersion (void);
char * Get_ShortDate (void);
char * Get_SystemDirectory (void);
char * Get_TempDirectory (void);
char * Get_Time (void);
char * Get_UserName (void);
char * Get_WindowsDirectory (void);
DWORD Get_CurrentDirectoryEx (char *sOutVal);
DWORD Get_FileSize(const char *sFileName);
DWORD Get_SystemDirectoryEx (char *sOutVal);
DWORD Get_TempDirectoryEx (char *sOutVal);
DWORD Get_WindowsDirectoryEx (char *sOutVal);
int Get_LongDateEx (char *sOutVal);
int Get_ShortDateEx (char *sOutVal);
int Get_TimeEx (char *sOutVal);
void Get_LocalDateTime(DWORD *dwDate, DWORD *dwTime);
void Get_OsVersionEx (char *sOutVal);
void Get_SystemDateTime(DWORD *dwDate, DWORD *dwTime);
void SetApplicationPriority(HANDLE hProcess, HANDLE hThread, int iPriorityClass, short iThreadPriority, bool bProcessBoost, bool bThreadBoost);

//_STRING_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool CompareCSString(const char *sBuf1, const char *sBuf2);
bool CompareNCString(const char *sBuf1, const char *sBuf2);
bool IsLower(char cIn);
bool IsNumber(char cIn);
bool IsNumeric(char *sText);
bool IsUpper(char cIn);
bool IsWhiteSpace(char cChar);
bool ReverseString(char *sBuf, int iBufSz);
char * LCaseEx (char *sBuf, int iBufSz);
char * UCaseEx (char *sBuf, int iBufSz);
char **Split(char *sBuf, char *sSplitOn);
char **SplitEx(char *sBuf, int iBufSz, char **sArray, int *iOutItems, char *sSplitOn, int iSplitOnSz);
char *FormatInteger(char *sOut, const long lIn);
char *FormatiString(char *sOut, const char *sIn);
char *LCase (char *sBuf);
char *SimpleCipherString(char *sBuf, int iBufSz);
char *StringScan(const char *sInBuf, int iStartPos, int iLength);
char *UCase (char *sBuf);
char ToLower(char cIn);
char ToUpper(char cIn);
int AppendStrings(const char *sBuf1, const char *sBuf2, int iBuf1Sz, int iBuf2Sz, char *sOutBuf);
int CompareFlagedString(const char *sBuf, const char *sFlag);
int CopyString(char *sOutBuf, const char *sInBuf, int iInBufSz);
int GetFirstCharPos(char *sInBuf, int iInBufSz);
int GetFlagedValue(const char *sBuf, int iSkpLen, int iBufSz, char *sOutBuf);
int GetLastCharPos(char *sInBuf, int iInBufSz);
int InStr(const char *sSearchFor, const char *sInBuf);
int InStrEx(const char *sSearchFor, const char *sInBuf, const int iBufSz, const int iStartPos);
int InStrExx(const char *sSearchFor, int sSearchForSz, const char *sInBuf, const int iBufSz, const int iStartPos);
int Left(const char *sInBuf, char *sOutBuf, int iInLen, int iLeft);
int MidEx(const char *sInBuf, int iInBufSz, int iStartPos, int iRChars, char *sOutBuf);
int ReplaceCharacter(const char *sInBuf, char *sOutBuf, const char cReplace, const char cWith);
int ReplaceStrings (const char *sInBuf, const char *sReplace, const char *sWith, char *sOutBuf);
int Right(const char *sInBuf, char *sOutBuf, int iInLen, int iRight);
int StrCatEx(char *sOutBuf, const char *sInBuf, int iInBufSz, int iOutBufSz);
int StringScanEx(const char *sInBuf, int iStartPos, int iLength, char *sOutVal);
int UBound(char **sArray);
void FreeArray(char **sArray);
void FreeArrayEx(char **sArray, int iItems);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
